// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : sound.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "sound.h"
#include "Log.h"

#include <string>
#include <strsafe.h>



#define URL_SOUNDS            "sounds/"



LPDIRECTSOUND8                            Sound::s_pDSound = NULL;
std::vector<LPDIRECTSOUNDBUFFER>          Sound::s_allBuffers;
std::map<std::string,LPDIRECTSOUNDBUFFER> Sound::s_mapBuffers;
int                                       Sound::s_MasterVolume = 100;

// Logarithmic table to get a linear volume factor
int Sound::s_VolumeRange[101] = { -10000, -6644, -5644, -5059, -4644,
                                   -4322, -4059, -3837, -3644, -3474,
                                   -3322, -3184, -3059, -2943, -2837,
                                   -2737, -2644, -2556, -2474, -2396,
                                   -2322, -2252, -2184, -2120, -2059,
                                   -2000, -1943, -1889, -1837, -1786,
                                   -1737, -1690, -1644, -1599, -1556,
                                   -1515, -1474, -1434, -1396, -1358,
                                   -1322, -1286, -1252, -1218, -1184,
                                   -1152, -1120, -1089, -1059, -1029,
                                   -1000,  -971,  -943,  -916,  -889,
                                    -862,  -837,  -811,  -786,  -761,
                                    -737,  -713,  -690,  -667,  -644,
                                    -621,  -599,  -578,  -556,  -535,
                                    -515,  -494,  -474,  -454,  -434,
                                    -415,  -396,  -377,  -358,  -340,
                                    -322,  -304,  -286,  -269,  -252,
                                    -234,  -218,  -201,  -184,  -168,
                                    -152,  -136,  -120,  -105,   -89,
                                     -74,   -59,   -44,   -29,   -14,
                                     0 };



Sound::Sound() :
  m_pBuffer( NULL )
{

  /*
  if ( s_mapBuffers[filename] != NULL ) 
  {
    // If exists, copy reference buffer into the local secondary buffer
    s_pDSound->DuplicateSoundBuffer( s_mapBuffers[filename], &m_pBuffer );
  } 
  else 
  {
    Log( "Sound()  Sound '%s' does not exist.\n", filename );
    m_pBuffer = NULL;
  }
  */

}



Sound::~Sound() 
{
  if ( m_pBuffer != NULL )
  {
    m_pBuffer->Release();
  }
}



void Sound::Play() 
{
  if ( m_pBuffer != NULL ) 
  {
    m_pBuffer->SetCurrentPosition( 0 );
    m_pBuffer->SetVolume( s_VolumeRange[s_MasterVolume] );
    m_pBuffer->Play( 0, 0, 0 );
  }
}



void Sound::Loop() 
{
  if ( m_pBuffer != NULL ) 
  {
    m_pBuffer->SetCurrentPosition( 0 );
    m_pBuffer->SetVolume( s_VolumeRange[s_MasterVolume] );
    m_pBuffer->Play( 0, 0, DSBPLAY_LOOPING );
  }
}



void Sound::Stop() 
{
  if ( m_pBuffer != NULL )
  {
    m_pBuffer->Stop();
  }
}



void Sound::Init( HWND hWnd ) 
{

  Log( "Initializing Sound...\n" );

  // Create sound device
  DirectSoundCreate8( NULL, &s_pDSound, NULL );
  s_pDSound->SetCooperativeLevel( hWnd, DSSCL_PRIORITY );

  preloadAllSounds();

}



void Sound::Release() 
{
  Log( "Releasing Sound...\n" );

  // Loop through all reference buffers and release
  std::vector<LPDIRECTSOUNDBUFFER>::iterator  b;
  for ( b = s_allBuffers.begin(); b != s_allBuffers.end(); b++ ) 
  {
    (*b)->Release();
  }

  s_pDSound->Release();

}



bool Sound::PreloadSound( const char* filename ) 
{
  char    pathname[MAX_PATH];

  sprintf_s( pathname, MAX_PATH, "%s%s", URL_SOUNDS, filename );

  WAVEFORMATEX    wfx;
  HMMIO           hFile;
  UCHAR*          waveBuffer = NULL;
  LPDIRECTSOUNDBUFFER dsBuffer;
  LPVOID          pLockedBuffer;
  DWORD           dwLockedBufferSize;
  DWORD           dwBufferSize;

  // Setup media file chunks for reading
  MMCKINFO        primary;
  MMCKINFO        secondary;

  primary.ckid         = (FOURCC)0;
  primary.cksize       = 0;
  primary.fccType      = (FOURCC)0;
  primary.dwDataOffset = 0;
  primary.dwFlags      = 0;
  secondary            = primary;

  // Attempt to open sound file
  hFile = mmioOpenA( pathname, NULL, MMIO_READ | MMIO_ALLOCBUF );
  if ( hFile == NULL ) 
  {
    Log( "Sound()  Error(%s): Failed to open with mmioOpenA().", filename );
    return false;
  }

  // Ensure valid WAV format
  primary.fccType = mmioFOURCC( 'W', 'A', 'V', 'E' );
  if ( mmioDescend( hFile, &primary, NULL, MMIO_FINDRIFF ) ) 
  {
    mmioClose( hFile, 0 );
    Log( "Sound()  Error(%s): Failed to find RIFF chunk with mmioDescend().", filename );
    return false;
  }

  // Locate secondary "FMT " chunk
  secondary.ckid = mmioFOURCC( 'f', 'm', 't', ' ' );
  if ( mmioDescend( hFile, &secondary, &primary, MMIO_FINDCHUNK ) ) 
  {
    mmioClose( hFile, 0 );
    Log( "Sound()  Error(%s): Failed to find format chunk with mmioDescend().", filename );
    return false;
  }

  // Ensure WAVEFORMATEX is valid
  if ( mmioRead( hFile, (char*)&wfx, sizeof( wfx ) ) != sizeof( wfx ) ) 
  {
    mmioClose( hFile, 0 );
    Log( "Sound()  Error(%s): Invalid WAVEFORMATEX extracted with mmioRead().", filename );
    return false;
  }

  // Check for PCM format   
  if ( wfx.wFormatTag != WAVE_FORMAT_PCM ) 
  {
    mmioClose( hFile, 0 );
    Log( "Sound()  Error(%s): WAV not in PCM format.", filename );
    return false;
  }

  // Move file pointer to secondary chunk
  if ( mmioAscend( hFile, &secondary, 0 ) ) 
  {
    mmioClose( hFile, 0 );
    Log( "Sound()  Error(%s): Failed to access secondary chunk with mmioAscend().", filename );
    return false;
  }

  // Read data chunk
  secondary.ckid = mmioFOURCC( 'd', 'a', 't', 'a' );
  if ( mmioDescend( hFile, &secondary, &primary, MMIO_FINDCHUNK ) ) 
  {
    mmioClose( hFile, 0 );
    Log( "Sound()  Error(%s): Failed to read data with mmioDescend().", filename );
    return false;
  }

  // Obtain secondary chunk buffer size
  dwBufferSize = secondary.cksize;

  // Create sound buffer of same chunk size
  waveBuffer = new UCHAR[dwBufferSize];

  // Copy data from file to sound buffer
  long bytesRead = mmioRead( hFile, (char*)waveBuffer, secondary.cksize );

  // Ensure sound data is not empty
  if ( bytesRead < 0 ) 
  {
    mmioClose( hFile, 0 );
    Log( "Sound()  Error(%s): No data found with mmioRead().", filename );
    return false;
  }

  // Close sound file
  mmioClose( hFile, 0 );

  // Create secondary (static) buffer (for reference)
  DSBUFFERDESC         dsbd;
  ZeroMemory( &dsbd, sizeof( DSBUFFERDESC ) );    // clear out the struct for use
  dsbd.dwSize           = sizeof( DSBUFFERDESC );
  dsbd.dwFlags          = DSBCAPS_CTRLVOLUME | DSBCAPS_STATIC;
  dsbd.dwBufferBytes    = dwBufferSize;
  dsbd.guid3DAlgorithm  = GUID_NULL;
  dsbd.lpwfxFormat      = &wfx;
  s_pDSound->CreateSoundBuffer( &dsbd, &dsBuffer, NULL );
  dsBuffer->SetVolume( 0 );

  // Lock buffer
  HRESULT hr = dsBuffer->Lock( 0,          // Offset at which to start lock
                               0,          // Size of lock; ignored because of flag
                               &pLockedBuffer,  // Address of first part of lock
                               &dwLockedBufferSize,  // Size of first part of lock
                               NULL,       // Address of wraparound -- not needed
                               NULL,       // Size of wraparound -- not needed
                               DSBLOCK_ENTIREBUFFER );     // Flag

  // Load sound data into secondary buffer
  memcpy( pLockedBuffer, waveBuffer, dwLockedBufferSize );
  delete[] waveBuffer;

  // Unlock buffer
  dsBuffer->Unlock( pLockedBuffer,  // Address of lock start
                    dwLockedBufferSize,  // Size of lock
                    NULL,      // No wraparound portion
                    0);        // No wraparound size


  // Append image to sprite frame vector
  m_pBuffer = dsBuffer;
  return true;

}



void Sound::preloadAllSounds() 
{

  /*
  DWORD dwError = 0;

  // Prepare string for use with FindFile functions.  First, copy the
  // string to a buffer, then append '\*.wav' to the directory name.
  size_t  i;
  char    filename[MAX_PATH];
  TCHAR   pathname[MAX_PATH];

  StringCchCopy( pathname, MAX_PATH, TEXT( URL_SOUNDS ) );
  StringCchCat( pathname, MAX_PATH, L"\\*.wav" );

  // Find the first file in the directory.
  WIN32_FIND_DATA ffd;
  HANDLE hFind = FindFirstFile( pathname, &ffd );

  // Check if any files exist
  if ( hFind == INVALID_HANDLE_VALUE ) 
  {
    dwError = GetLastError();
    Log( "Sound()  Error(%u): No files were found in the resource directory '%s'.", dwError, URL_SOUNDS );
  } 
  else 
  {
    // Preload first sound
    wcstombs_s( &i, filename, MAX_PATH, ffd.cFileName, MAX_PATH );
    preloadSound( filename );

    // List and preload remaining sound files in the directory.
    while ( FindNextFile( hFind, &ffd ) != 0 ) 
    {
      wcstombs_s( &i, filename, MAX_PATH, ffd.cFileName, MAX_PATH );
      preloadSound( filename );
    }

    // Check for errors
    dwError = GetLastError();
    if ( dwError != ERROR_NO_MORE_FILES ) 
    {
      Log( "Sound()  Error(%u): Problem reading sounds from '%s'.", dwError, URL_SOUNDS );
    }

    // Close file handle
    FindClose( hFind );
  }
  */
}



int Sound::Volume()
{

  return s_MasterVolume;

}



void Sound::SetVolume( int Volume )
{

  if ( Volume < 0 )
  {
    Volume = 0;
  }
  if ( Volume > 100 )
  {
    Volume = 100;
  }
  s_MasterVolume = Volume;
  std::vector<LPDIRECTSOUNDBUFFER>::iterator  b;
  for ( b = s_allBuffers.begin(); b != s_allBuffers.end(); b++ ) 
  {
    LPDIRECTSOUNDBUFFER   pBuffer = *b;

    pBuffer->SetVolume( s_VolumeRange[Volume] );
  }

}



bool Sound::IsPlaying() const
{

  if ( m_pBuffer == NULL )
  {
    return false;
  }
  DWORD   Status = 0;
  if ( FAILED( m_pBuffer->GetStatus( &Status ) ) )
  {
    return false;
  }
  return ( Status & DSBSTATUS_PLAYING  );

}



void Sound::Duplicate( Sound* pOrigSound )
{

  s_pDSound->DuplicateSoundBuffer( pOrigSound->m_pBuffer, &m_pBuffer );

}